###LOAD DEPENDENT PACKAGES
library(xlsx)
library(rstatix)
library(outliers)
library(ggplot2)
library(ggpubr)

###FORMAT DATA
Data <- read.xlsx("Discrete_Kinematics.xlsx", sheetIndex = 1)
Data[,4:23] <- abs(Data[,4:23])
Knee <- Data[,c(1,9:13)]

###OUTLIER IDENTIFICATION

Ay.Knee <- Knee[1:30,]
Ma.Knee <- Knee[31:60,]
Ir.Knee <- Knee[61:90,]

#Grubb's test to identify outliers
#Aylesburys
for(i in 2:ncol(Ay.Knee)){
  DV <- names(Ay.Knee[i])
  res.grub <- grubbs.test(Ay.Knee[,i], type = 11) #test if highest and lowest values are outliers
  print(DV)
  print(res.grub)
}
#Mallards
for(i in 2:ncol(Ma.Knee)){
  DV <- names(Ma.Knee[i])
  res.grub <- grubbs.test(Ma.Knee[,i], type = 11) #test if highest and lowest values are outliers
  print(DV)
  print(res.grub)
}
#Runners
for(i in 2:ncol(Ir.Knee)){
  DV <- names(Ir.Knee[i])
  res.grub <- grubbs.test(Ir.Knee[,i], type = 11) #test if highest and lowest values are outliers
  print(DV)
  print(res.grub)
}

#Boxplots to investigation data distribution

Box.Knee.Max <- ggplot(Knee, aes(x=Breed, y=Knee_Max_Flex, fill=Breed)) + 
  geom_boxplot(width=0.8, lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Maximum Knee Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Box.Knee.Min <- ggplot(Knee, aes(x=Breed, y=Knee_Min_Flex, fill=Breed)) + 
  geom_boxplot(width=0.8, lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Minimum Knee Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Box.Toe.On <- ggplot(Knee, aes(x=Breed, y=Knee_Toe_on, fill=Breed)) + 
  geom_boxplot(width=0.8, lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Toe-on Knee Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Box.Toe.Off <- ggplot(Knee, aes(x=Breed, y=Knee_Toe_off, fill=Breed)) + 
  geom_boxplot(width=0.8, lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Toe-off Knee Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Box.Mid.Stance <- ggplot(Knee, aes(x=Breed, y=Knee_Mid_Stance, fill=Breed)) + 
  geom_boxplot(width=0.8, lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Mid-stance Knee Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

#combine and publish violin plots
tiff(filename = "Boxplot_Knee.tif", width = 166, height = 166, units = "mm", res = 600, compression = "lzw") #166x166*2 or 166x166*1.5

plot.new()

ggarrange(Box.Knee.Max, 
          Box.Knee.Min, 
          Box.Toe.On, 
          Box.Toe.Off, 
          Box.Mid.Stance, 
          labels = c("A", "B", "C", "D", "E"),
          hjust = -4,
          ncol = 2, nrow = 3)

dev.off()

###MAIN ANALYSIS

#Seperate variables to individual columns (required as outliers are omitted via row deletion)
Knee.Max.Flex.Data <- Knee[,1:2]
Knee.Min.Flex.Data <- Knee[,c(1,3)]
Knee.Toe.On.Data <- Knee[,c(1,4)]
Knee.Toe.Off.Data <- Knee[,c(1,5)]
Knee.Mid.Stance.Data <- Knee[,c(1,6)]

#Omit outliers (currently performed manually)
Knee.Min.Flex.Data <- Knee.Min.Flex.Data[!(row.names(Knee.Min.Flex.Data) %in% c("18")),]
Knee.Min.Flex.Data <- Knee.Min.Flex.Data[!(row.names(Knee.Min.Flex.Data) %in% c("5")),]
Knee.Min.Flex.Data <- Knee.Min.Flex.Data[!(row.names(Knee.Min.Flex.Data) %in% c("13")),]
Knee.Min.Flex.Data <- Knee.Min.Flex.Data[!(row.names(Knee.Min.Flex.Data) %in% c("4")),]
Knee.Min.Flex.Data <- Knee.Min.Flex.Data[!(row.names(Knee.Min.Flex.Data) %in% c("10")),]
Knee.Min.Flex.Data <- Knee.Min.Flex.Data[!(row.names(Knee.Min.Flex.Data) %in% c("8")),]
Knee.Min.Flex.Data <- Knee.Min.Flex.Data[!(row.names(Knee.Min.Flex.Data) %in% c("7")),]

Knee.Toe.On.Data <- Knee.Toe.On.Data[!(row.names(Knee.Toe.On.Data) %in% c("80")),]

Knee.Mid.Stance.Data <- Knee.Mid.Stance.Data[!(row.names(Knee.Mid.Stance.Data) %in% c("62")),]

#Shapiro-Wilks Test for Normality
res.shap <- shapiro_test(Knee.Min.Flex.Data[,2])
print(res.shap)
res.shap <- shapiro_test(Knee.Max.Flex.Data[,2])
print(res.shap)
res.shap <- shapiro_test(Knee.Toe.On.Data[,2])
print(res.shap)
res.shap <- shapiro_test(Knee.Toe.Off.Data[,2])
print(res.shap)
res.shap <- shapiro_test(Knee.Mid.Stance.Data[,2])
print(res.shap)

#Levene's test for homogeneity of variance
res.lt <- levene_test(Knee.Min.Flex.Data[,2] ~ Breed, data = Knee.Min.Flex.Data)
print(res.lt)
res.lt <- levene_test(Knee.Max.Flex.Data[,2] ~ Breed, data = Knee.Max.Flex.Data)
print(res.lt)
res.lt <- levene_test(Knee.Toe.On.Data[,2] ~ Breed, data = Knee.Toe.On.Data)
print(res.lt)
res.lt <- levene_test(Knee.Toe.Off.Data[,2] ~ Breed, data = Knee.Toe.Off.Data)
print(res.lt)
res.lt <- levene_test(Knee.Mid.Stance.Data[,2] ~ Breed, data = Knee.Mid.Stance.Data)
print(res.lt)

#Kruskal-Wallis Test & output to .xls
KW.Knee.Min.Flex <- data.frame(matrix(nrow = 2, ncol = 7))
ES.Knee.Min.Flex <- data.frame(matrix(nrow = 2, ncol = 6))
res.KW <- kruskal_test(Knee.Min.Flex.Data[,2] ~ Breed, data = Knee.Min.Flex.Data)
res.ES <- kruskal_effsize(Knee.Min.Flex.Data[,2] ~ Breed, data = Knee.Min.Flex.Data)
print(res.KW)
print(res.ES)
KW.Knee.Min.Flex[i,] <- data.frame(var = names(Knee.Min.Flex.Data[2]), res.KW, row.names = NULL)
ES.Knee.Min.Flex[i,] <- data.frame(var = names(Knee.Min.Flex.Data[2]), res.ES, row.names = NULL)
colnames(KW.Knee.Min.Flex) <- c("Parameter", "y", "n", "statistic", "df", "p", "method")
colnames(ES.Knee.Min.Flex) <- c("Parameter", "y", "n", "effsize", "method", "magnitude")
Final.Knee.Min.Flex <- cbind(KW.Knee.Min.Flex, ES.Knee.Min.Flex)
Final.Knee.Min.Flex <- Final.Knee.Min.Flex[ -c(2, 7:10, 12:13) ]
Final.Knee.Min.Flex <- Final.Knee.Min.Flex[ -c(1:5), ]

KW.Knee.Max.Flex <- data.frame(matrix(nrow = 2, ncol = 7))
ES.Knee.Max.Flex <- data.frame(matrix(nrow = 2, ncol = 6))
res.KW <- kruskal_test(Knee.Max.Flex.Data[,2] ~ Breed, data = Knee.Max.Flex.Data)
res.ES <- kruskal_effsize(Knee.Max.Flex.Data[,2] ~ Breed, data = Knee.Max.Flex.Data)
print(res.KW)
print(res.ES)
KW.Knee.Max.Flex[i,] <- data.frame(var = names(Knee.Max.Flex.Data[2]), res.KW, row.names = NULL)
ES.Knee.Max.Flex[i,] <- data.frame(var = names(Knee.Max.Flex.Data[2]), res.ES, row.names = NULL)
colnames(KW.Knee.Max.Flex) <- c("Parameter", "y", "n", "statistic", "df", "p", "method")
colnames(ES.Knee.Max.Flex) <- c("Parameter", "y", "n", "effsize", "method", "magnitude")
Final.Knee.Max.Flex <- cbind(KW.Knee.Max.Flex, ES.Knee.Max.Flex)
Final.Knee.Max.Flex <- Final.Knee.Max.Flex[ -c(2, 7:10, 12:13) ]
Final.Knee.Max.Flex <- Final.Knee.Max.Flex[ -c(1:5), ]

KW.Knee.Toe.On <- data.frame(matrix(nrow = 2, ncol = 7))
ES.Knee.Toe.On <- data.frame(matrix(nrow = 2, ncol = 6))
res.KW <- kruskal_test(Knee.Toe.On.Data[,2] ~ Breed, data = Knee.Toe.On.Data)
res.ES <- kruskal_effsize(Knee.Toe.On.Data[,2] ~ Breed, data = Knee.Toe.On.Data)
print(res.KW)
print(res.ES)
KW.Knee.Toe.On[i,] <- data.frame(var = names(Knee.Toe.On.Data[2]), res.KW, row.names = NULL)
ES.Knee.Toe.On[i,] <- data.frame(var = names(Knee.Toe.On.Data[2]), res.ES, row.names = NULL)
colnames(KW.Knee.Toe.On) <- c("Parameter", "y", "n", "statistic", "df", "p", "method")
colnames(ES.Knee.Toe.On) <- c("Parameter", "y", "n", "effsize", "method", "magnitude")
Final.Knee.Toe.On <- cbind(KW.Knee.Toe.On, ES.Knee.Toe.On)
Final.Knee.Toe.On <- Final.Knee.Toe.On[ -c(2, 7:10, 12:13) ]
Final.Knee.Toe.On <- Final.Knee.Toe.On[ -c(1:5), ]

KW.Knee.Toe.Off <- data.frame(matrix(nrow = 2, ncol = 7))
ES.Knee.Toe.Off <- data.frame(matrix(nrow = 2, ncol = 6))
res.KW <- kruskal_test(Knee.Toe.Off.Data[,2] ~ Breed, data = Knee.Toe.Off.Data)
res.ES <- kruskal_effsize(Knee.Toe.Off.Data[,2] ~ Breed, data = Knee.Toe.Off.Data)
print(res.KW)
print(res.ES)
KW.Knee.Toe.Off[i,] <- data.frame(var = names(Knee.Toe.Off.Data[2]), res.KW, row.names = NULL)
ES.Knee.Toe.Off[i,] <- data.frame(var = names(Knee.Toe.Off.Data[2]), res.ES, row.names = NULL)
colnames(KW.Knee.Toe.Off) <- c("Parameter", "y", "n", "statistic", "df", "p", "method")
colnames(ES.Knee.Toe.Off) <- c("Parameter", "y", "n", "effsize", "method", "magnitude")
Final.Knee.Toe.Off <- cbind(KW.Knee.Toe.Off, ES.Knee.Toe.Off)
Final.Knee.Toe.Off <- Final.Knee.Toe.Off[ -c(2, 7:10, 12:13) ]
Final.Knee.Toe.Off <- Final.Knee.Toe.Off[ -c(1:5), ]

KW.Knee.Mid.Stance <- data.frame(matrix(nrow = 2, ncol = 7))
ES.Knee.Mid.Stance <- data.frame(matrix(nrow = 2, ncol = 6))
res.KW <- kruskal_test(Knee.Mid.Stance.Data[,2] ~ Breed, data = Knee.Mid.Stance.Data)
res.ES <- kruskal_effsize(Knee.Mid.Stance.Data[,2] ~ Breed, data = Knee.Mid.Stance.Data)
print(res.KW)
print(res.ES)
KW.Knee.Mid.Stance[i,] <- data.frame(var = names(Knee.Mid.Stance.Data[2]), res.KW, row.names = NULL)
ES.Knee.Mid.Stance[i,] <- data.frame(var = names(Knee.Mid.Stance.Data[2]), res.ES, row.names = NULL)
colnames(KW.Knee.Mid.Stance) <- c("Parameter", "y", "n", "statistic", "df", "p", "method")
colnames(ES.Knee.Mid.Stance) <- c("Parameter", "y", "n", "effsize", "method", "magnitude")
Final.Knee.Mid.Stance <- cbind(KW.Knee.Mid.Stance, ES.Knee.Mid.Stance)
Final.Knee.Mid.Stance <- Final.Knee.Mid.Stance[ -c(2, 7:10, 12:13) ]
Final.Knee.Mid.Stance <- Final.Knee.Mid.Stance[ -c(1:5), ]

write.xlsx(Final.Knee.Min.Flex, file = "KW_Knee.xlsx", sheetName = "Knee.Min.Flex")
write.xlsx(Final.Knee.Max.Flex, file = "KW_Knee.xlsx", sheetName = "Knee.Max.Flex", append = TRUE)
write.xlsx(Final.Knee.Toe.On, file = "KW_Knee.xlsx", sheetName = "Knee.Toe.On", append = TRUE)
write.xlsx(Final.Knee.Toe.Off, file = "KW_Knee.xlsx", sheetName = "Knee.Toe.Off", append = TRUE)
write.xlsx(Final.Knee.Mid.Stance, file = "KW_Knee.xlsx", sheetName = "Knee.Mid.Stance", append = TRUE)

#Dunn's Test & output to .xls
dunn_vector <- Vectorize(dunn_test, vectorize.args="formula", SIMPLIFY=F)
reformulate <- Vectorize(reformulate, vectorize.args="response")
DN.Knee.Min.Flex <- dunn_vector(Knee.Min.Flex.Data, reformulate("Breed", names(Knee.Min.Flex.Data)[2]), p.adjust.method="bonferroni") #2:15 for linear measurements 2:11 for hulls
DN.Knee.Min.Flex

dunn_vector <- Vectorize(dunn_test, vectorize.args="formula", SIMPLIFY=F)
reformulate <- Vectorize(reformulate, vectorize.args="response")
DN.Knee.Max.Flex <- dunn_vector(Knee.Max.Flex.Data, reformulate("Breed", names(Knee.Max.Flex.Data)[2]), p.adjust.method="bonferroni") #2:15 for linear measurements 2:11 for hulls
DN.Knee.Max.Flex

dunn_vector <- Vectorize(dunn_test, vectorize.args="formula", SIMPLIFY=F)
reformulate <- Vectorize(reformulate, vectorize.args="response")
DN.Knee.Toe.On <- dunn_vector(Knee.Toe.On.Data, reformulate("Breed", names(Knee.Toe.On.Data)[2]), p.adjust.method="bonferroni") #2:15 for linear measurements 2:11 for hulls
DN.Knee.Toe.On

dunn_vector <- Vectorize(dunn_test, vectorize.args="formula", SIMPLIFY=F)
reformulate <- Vectorize(reformulate, vectorize.args="response")
DN.Knee.Toe.Off <- dunn_vector(Knee.Toe.Off.Data, reformulate("Breed", names(Knee.Toe.Off.Data)[2]), p.adjust.method="bonferroni") #2:15 for linear measurements 2:11 for hulls
DN.Knee.Toe.Off

dunn_vector <- Vectorize(dunn_test, vectorize.args="formula", SIMPLIFY=F)
reformulate <- Vectorize(reformulate, vectorize.args="response")
DN.Knee.Mid.Stance <- dunn_vector(Knee.Mid.Stance.Data, reformulate("Breed", names(Knee.Mid.Stance.Data)[2]), p.adjust.method="bonferroni") #2:15 for linear measurements 2:11 for hulls
DN.Knee.Mid.Stance

write.xlsx(DN.Knee.Min.Flex, file = "Dunn_Knee.xlsx", sheetName = "Knee.Min.Flex")
write.xlsx(DN.Knee.Max.Flex, file = "Dunn_Knee.xlsx", sheetName = "Knee.Max.Flex", append = TRUE)
write.xlsx(DN.Knee.Toe.On, file = "Dunn_Knee.xlsx", sheetName = "Knee.Toe.On", append = TRUE)
write.xlsx(DN.Knee.Toe.Off, file = "Dunn_Knee.xlsx", sheetName = "Knee.Toe.Off", append = TRUE)
write.xlsx(DN.Knee.Mid.Stance, file = "Dunn_Knee.xlsx", sheetName = "Knee.Mid.Stance", append = TRUE)

#Violin Plots
Violin.Knee.Min.Flex <- ggplot(Knee.Min.Flex.Data, aes(x=Breed, y=Knee_Min_Flex, fill=Breed)) + 
  geom_violin(trim = TRUE, lwd=1) +
  geom_boxplot(width=0.05, fill="white", lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Minimum Knee Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Violin.Knee.Max.Flex <- ggplot(Knee.Max.Flex.Data, aes(x=Breed, y=Knee_Max_Flex, fill=Breed)) + 
  geom_violin(trim = TRUE, lwd=1) +
  geom_boxplot(width=0.05, fill="white", lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Maximum Knee Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Violin.Knee.Toe.On <- ggplot(Knee.Toe.On.Data, aes(x=Breed, y=Knee_Toe_on, fill=Breed)) + 
  geom_violin(trim = TRUE, lwd=1) +
  geom_boxplot(width=0.05, fill="white", lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Toe-on Knee Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Violin.Knee.Toe.Off <- ggplot(Knee.Toe.Off.Data, aes(x=Breed, y=Knee_Toe_off, fill=Breed)) + 
  geom_violin(trim = TRUE, lwd=1) +
  geom_boxplot(width=0.05, fill="white", lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Toe-off Knee Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Violin.Knee.Mid.Stance <- ggplot(Knee.Mid.Stance.Data, aes(x=Breed, y=Knee_Mid_Stance, fill=Breed)) + 
  geom_violin(trim = TRUE, lwd=1) +
  geom_boxplot(width=0.05, fill="white", lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Mid-stance Knee Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

#combine and publish violin plots
tiff(filename = "Violin_Knee.tif", width = 166, height = 166, units = "mm", res = 600, compression = "lzw") #166x166*2 or 166x166*1.5

plot.new()

ggarrange(Violin.Knee.Min.Flex, 
          Violin.Knee.Max.Flex, 
          Violin.Knee.Toe.On, 
          Violin.Knee.Toe.Off, 
          Violin.Knee.Mid.Stance, 
          labels = c("A", "B", "C", "D", "E"),
          hjust = -4,
          ncol = 2, nrow = 3)

dev.off()
